/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   箱体查看模组/箱体(大屏)添加(快速布局)模块逻辑
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.13
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_add_module */
/* exported mc_update_block_show_name_val */
/* exported mc_construct_module */
/* exported mc_construct_box_json */

/* global mc_sdk_param */
/* global mc_get_top_fun */
/* global obj_connect_window */
/* global obj_router_page */
/* global $ */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    添加模块 选中侧边对应项-传递标识对象-调用快速布局应用
 * 标识对象备注:
 *    obj_param = {
 *       row: ui_row_cnt, 行数
 *       col: ui_col_cnt, 列数
 *       width: 创建模块宽,
 *       height:创建模块高,
 *       b_clear_box: false 是否清屏
 *   };
 * 参数:
 *    @param { Promise<Number> } ui_row_cnt 创建行数
 *    @param { Promise<Number> } ui_col_cnt 创建列数
 *    @param { Promise<Boolean> } b_clear_screen 是否清屏
 *    @param { Promise<Boolean> } b_screen 是否在大屏
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数有误
 *     true 成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_add_module(ui_row_cnt,ui_col_cnt,b_clear_screen,b_screen) {
    if ("[object Number]" !== Object.prototype.toString.call(ui_row_cnt) || "[object Number]" !== Object.prototype.toString.call(ui_col_cnt)) {
        return false;
    }
    // 当前选中项
    var obj_select = document.getElementsByClassName("select_side_item")[0];
    var str_index = obj_select.getAttribute("index");
    var str_type = "";
    var obj_param = {
        row: ui_row_cnt,
        col: ui_col_cnt,
        width: obj_select.getAttribute("module_w"),
        height: obj_select.getAttribute("module_h"),
        b_clear_box: b_clear_screen,
        b_create_new: false
    };

    if (b_screen) {
        str_type = "box";
    } else {
        str_type = "mod";
    }

    // 新建块----------
    if ("-1" === str_index) {
        var ui_w = Number(obj_param.width);
        var ui_h = Number(obj_param.height);

        if (0 === ui_w || 0 === ui_h) {
            mc_get_top_fun("mc_alert_popout", "MC_LANG_SIZE_ERROR_NO_CREATE");
            return true;
        }
        // 新建块标识
        obj_param.b_create_new = true;
        obj_connect_window.PAGE_G_OBJ_ADD_MODULE = obj_param;
        obj_router_page.set_methods_for_call("mc_quick_layout_apply");
        return true;
    }

    // 添加现有块--------
    mc_get_top_fun("mc_select_side_btn", Number(str_index),str_type);
    obj_connect_window.PAGE_G_OBJ_ADD_MODULE = obj_param;
    obj_router_page.set_methods_for_call("mc_quick_layout_apply");
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建新模块
 * 参数:
 *    @param { Promise<Array> } ary_construct [可创建：boolean, 下标：number(存在模块为所处下标，不存在为-1)]/[不可创建,错误提示]
 *    @param { Promise<String> } str_type 类型 mod/box
 *    @param { Promise<String> } str_box_json 新建箱体json字串 可为空
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数有误
 *     true 成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_construct_module(ary_construct,str_type,str_box_json) {
    if ("[object Array]" !== Object.prototype.toString.call(ary_construct) || 2 < ary_construct.length ) {
        return false;
    }
    if ("string" !== typeof str_type || 0 === str_type.length) {
        return false;
    }
    var b_create_succeed = ary_construct[0];


    if (b_create_succeed) {
        var ui_index = ary_construct[1];

        if (-1 !== ary_construct[1]) {
            // 存在模块 选中侧边对应
            mc_get_top_fun("mc_select_side_btn",ui_index,str_type);
        } else {
            // 构建侧边
            if ("box" === str_type) {
                mc_get_top_fun("get_" + str_type + "_info", true,JSON.parse(str_box_json));
            } else {
                mc_get_top_fun("get_" + str_type + "_info", true);
            }
        }
    } else {
        // 创建失败
        mc_get_top_fun("mc_alert_popout", "MC_LANG_COST_MOD_ERROR_" + ary_construct[1]);
        return false;
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    新建箱体字串
 * 参数:
 *    @param { Promise<String> } str_ctrlchip 芯片name
 *    @param { Promise<String> } str_hub 芯片name
 *    @param { Promise<String> } str_width 创建箱体宽
 *    @param { Promise<String> } str_height 创建箱体高
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数有误
 *     true 成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_construct_box_json(str_ctrlchip,str_hub,str_width,str_height) {
    var obj_sdk_param = new mc_sdk_param();
    var str_param_name = "";

    obj_sdk_param.set_param_clear();
    str_param_name = "MC_LANG_CTRLCHIP_LIST";
    obj_sdk_param.set_param_value(str_param_name, str_ctrlchip);
    obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "LABEL");

    str_param_name = "MC_LANG_LABLE_HUB";
    obj_sdk_param.set_param_value(str_param_name, str_hub);
    obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "LABEL");

    str_param_name = "MC_LANG_LABLE_WEITH";
    obj_sdk_param.set_param_value(str_param_name, str_width);
    obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "LABEL");

    str_param_name = "MC_LANG_LABLE_HEIGHT";
    obj_sdk_param.set_param_value(str_param_name, str_height);
    obj_sdk_param.set_attr_val(str_param_name, "UI_TYPE", "LABEL");
    return obj_sdk_param.get_json();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    侧边修改实时联动添加模块数据; 更新显示名称
 * 参数:
 *    @param { Promise<String> } id === 模块的属性为 name_id 的值(数据源名称)
 *    @param { Promise<String> } val 新名称
 * 返回:
 *    @returns { Promise<Boolean> } true === 设置成功 || false === 失败
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-12-29
 *       内容 : 所有代码
************************************************************************************************/
function mc_update_block_show_name_val(id, val) {
    if ("string" !== typeof id || "string" !== typeof val) {
        return false;
    }

    var arr_add_block = $("#mc_contain .mc_msg");
    var arr_len = arr_add_block.length;

    if (0 === arr_len) {
        return false;
    }

    var arr_mod_cur = $("#mc_contain .mc_msg[name_id=" + id + "]");

    if (0 === arr_mod_cur.length) {
        return false;
    }

    arr_mod_cur.find(".mc_add_block_name").text(val);

    return true;
}


